# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pete Burgers <deltify81@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gettext
from gettext import gettext as _
gettext.textdomain('deltify')

import logging
logger = logging.getLogger(__name__)

from deltify.bookmarks import BookmarksStore, FIELDS
import deltify.settings as settings
import deltify.scanner as scanner
import deltify.task as task
import deltify.utils as utils
import deltify.renderers as renderers


class DeltifyConsole:
    def __init__(self):
        self.settings = settings.Settings()
        self.settings.load()
        self.bookmarks_store = BookmarksStore(self.settings.browser,
                                              self.settings.browser_profile,
                                              self.settings.bookmark_root_folder)

    def scan(self):
        """ Scan any bookmarks that are due to be scanned """
        for index, bookmark in enumerate(self.bookmarks_store):
            title = bookmark[FIELDS.title]
            if bookmark[FIELDS.is_skipped]:
                logger.info("Bookmark %s is set to skip", title)
                continue

            # Check last scan time here

            logger.info("Scanning %s...", title)
            scan = scanner.Scan()
            scan.run(bookmark)

            self.bookmarks_store.update_with_scan(index, scan)
            self.bookmarks_store.save()
        
        
