# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pete Burgers <deltify81@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# This is your preferences dialog.
#
# Define your preferences in
# data/glib-2.0/schemas/net.launchpad.deltify.gschema.xml
# See http://developer.gnome.org/gio/stable/GSettings.html for more info.

import gettext
from gettext import gettext as _
gettext.textdomain('deltify')

import logging
logger = logging.getLogger(__name__)

from gi.repository import Gio # pylint: disable=E0611

from deltify_lib.PropertiesDialog import PropertiesDialog
from deltify.bookmarks import FIELDS
import fields

class PropertiesDeltifyDialog(PropertiesDialog):
    __gtype_name__ = "PropertiesDeltifyDialog"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the properties dialog"""
        super(PropertiesDeltifyDialog, self).finish_initializing(builder)
        self.title_label = self.builder.get_object("title_label")
        self.uri_label = self.builder.get_object("uri_label")
        self.threshold_combo = self.builder.get_object("threshold_combo")
        
        for threshold in sorted(fields.THRESHOLDS.keys()):
            # Don't add the "Default" until we know what it is
            if threshold != fields.DEFAULT_VALUE:
                self.threshold_combo.append(str(threshold), fields.THRESHOLDS[threshold])

    def run(self, model, treeinter):
        self.title_label.set_text(model[treeinter][FIELDS.title])
        self.uri_label.set_text(model[treeinter][FIELDS.uri])

        settings = Gio.Settings("net.launchpad.deltify")
        default_change_threshold = int(settings.get_string("default-change-threshold"))

        # Add the default entry to the combobox
        self.threshold_combo.prepend(str(fields.DEFAULT_VALUE), 
                                     fields.THRESHOLDS[fields.DEFAULT_VALUE] % 
                                     default_change_threshold)
        threshold = model[treeinter][FIELDS.change_threshold]
        if threshold in fields.THRESHOLDS:
            self.threshold_combo.set_active_id(str(threshold))

        super(PropertiesDeltifyDialog, self).run()
        
    def get_change_threshold(self):
        threshold = self.threshold_combo.get_active_id()
        return int(threshold) if threshold else None
