# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pete Burgers <deltify81@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import optparse

import gettext
from gettext import gettext as _
gettext.textdomain('deltify')

from gi.repository import Gtk # pylint: disable=E0611

from deltify import DeltifyWindow, DeltifyConsole

from deltify_lib import set_up_logging, get_version

def parse_options():
    """Support for command line options"""
    parser = optparse.OptionParser(version="%%prog %s" % get_version())
    parser.add_option(
        "-v", "--verbose", action="count", dest="verbose",
        help=_("Show debug messages (-vv debugs deltify_lib also)"))
    parser.add_option(
        "-s", "--scan", action="store_true", dest="scan",
        help=_("Scan any bookmarks that are due to be scanned"))

    (options, args) = parser.parse_args()

    return (options, args)

def main():
    'constructor for your class instances'
    options, args = parse_options()
    set_up_logging(options)

    if options.scan:
        # Run the console application, scanning any bookmarks that are due
        console = DeltifyConsole.DeltifyConsole()
        console.scan()
    else:
        # Run the GUI application.    
        window = DeltifyWindow.DeltifyWindow()
        window.show()
        Gtk.main()
