# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pete Burgers <deltify81@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gettext
from gettext import gettext as _
gettext.textdomain('deltify')

plural = _("%d words")

DEFAULT_VALUE = -1

THRESHOLDS = {DEFAULT_VALUE: _("Default (Currently %d)"),
              0: _("None"),
              1: _("1 word"),
              2: _(plural % 2),
              5: _(plural % 5),
              10: _(plural % 10),
              20: _(plural % 20),
              50: _(plural % 50),
              100: _(plural % 100),
              }

class Fields(list):
    def __init__(self, fields):
        list.__init__(self, fields)

        self.names = []
        self.types = []
        self.defaults = []
        for field in self:
            self.names.append(field[0])
            self.types.append(field[1])
            try:
                default = field[2]
            except IndexError:
                default = None
            self.defaults.append(default)

    def __getattribute__(self, name):
        """ 
        Return the field index of the specified name.
        Use like: bookmark[field.fieldname]
        """
        if name in ["names", "types", "defaults", "values_for", "dict_for", "index_of"]:
            return object.__getattribute__(self, name)
        try:
            return self.index_of(name)
        except ValueError:
            return object.__getattribute__(self, name)

    def index_of(self, name):
        """ Returns the index of the specified field name """
        return self.names.index(name)
    
    def values_for(self, **kwds):
        """ Returns a full list of values. Any fields not in **kwds are set to their default value """
        values = self.defaults
        for name in kwds:
            values[self.index_of(name)] = kwds[name]
        return values

    def dict_for(self, values):
        """ Returns a dict of key/value pairs """
        return dict(zip(self.names, values))
