# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pete Burgers <deltify81@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611
from gi.repository import Pango

from deltify.bookmarks import FIELDS

def render_title(column, cell, model, tree_iter, data):
    bookmark = model[tree_iter]
    if bookmark[FIELDS.is_skipped]:
        cell.set_property("foreground", "Gray")
        cell.set_property("weight", Pango.Weight.NORMAL)
    elif bookmark[FIELDS.is_error]:
        cell.set_property("foreground", "DarkRed")
        cell.set_property("weight", Pango.Weight.NORMAL)
    else:
        cell.set_property("foreground", "Black")
        if bookmark[FIELDS.is_changed]:
            cell.set_property("weight", Pango.Weight.BOLD)
        else:
            cell.set_property("weight", Pango.Weight.NORMAL)
